/*REXX*/
/**
==ChkIMAP==

ChkIMAP.cmd

Rexx script to check IMAP mail box for new messages. 
It was made after and similar to ChkPOP.cmd which 
used to check for new POP3 messages.


===Usage===

ChkIMAP.cmd [mailbox@]server[:port] user pass [debug]

mailbox -- mailbox name (default is Inbox)
server  -- IMAP Server name to connect to
port    -- port number to connect to (default is 143)
user    -- user login name
pass    -- user login password
debug   -- any value to see session protocol


===History===

 * 02.06.2007 Initial release
 * 09.06.2007 added debug switch, look for unseen messages
 * 19.15.2008 minor typo error corrected (to make OORexx happy)
 * 19.15.2008 mailbox as parameter

*/

/* some constants */
!.version = 0.3
IMAP_PORT = 143
mbox      = "INBOX"

parse arg host user pass !.debug

say "IMAP checker, ver "!.version

if pass == "" then do
	say "Examine IMAP mailbox for new messages."
	say
	say "Usage:"
	say "  ChkIMAP.cmd server[:port] user pass [debug]"
	say
	say "mailbox -- mailbox name (default is Inbox)"
	say "server  -- IMAP Server name to connect to"
	say "port    -- port number to connect to (default is 143)"
	say "user    -- user login name"
	say "pass    -- user login password"
	say "debug   -- any value to see session protocol"
	exit
end

parse var host host':'port
if port == "" then port = IMAP_PORT
if pos('@',host) > 0 then parse var host mbox'@'host

say "Examine "mbox"@"host" for user "user
say

If RxFuncQuery("SockDropFuncs") then do
	rc = RxFuncAdd("SockLoadFuncs","rxsock","SockLoadFuncs")
	rc = SockLoadFuncs()
end

if SockGetHostByName(host, result.) == 0 then do
	Error(socket, 100, "unable to resolve server name" host)
	exit
end

server.family = AF_INET
server.addr = result.addr
server.port = port

socket = SockSocket(AF_INET, SOCK_STREAM, IPPROTO_TCP)

if !.debug \= '' then say 'Debug: socket='socket

if socket <= 0 then do
	Error(socket, 100, "cannot open socket" socket)
	exit
end

if SockConnect(socket, server.) < 0 then do
	Error(socket, 100, "cannot connect to "host":"port)
	exit
end

rc = SendMessage(socket, "CAPABILITY")
rc = GetResponse(socket)

rc = SendMessage(socket, "LOGIN "||user||" "||pass)
rc = GetResponse(socket)

/* use EXAMINE instead SELECT to prevent \Recent flag modification */
rc = SendMessage(socket, "EXAMINE "||mbox)
rc = GetResponse(socket)

do i=0 to line.0
	parse var line.i "*" qty status
	if status == "RECENT" then
		say "Recent "qty" message(s)."
	else if status == "EXISTS" then
		say "Total "qty" message(s)."
end

/* look for unseen messages... */
rc = SendMessage(socket, "SEARCH UNSEEN")
rc = GetResponse(socket)
say "Unseen "||(words(line.1)-2)||" message(s)."

/*
rc = SendMessage(socket, "FETCH 1:2 (BODY[HEADER.FIELDS(DATE FROM SUBJECT)])")
rc = GetResponse(socket)
*/
rc = SendMessage(socket, "LOGOUT")
rc = GetResponse(socket)

rc = SockClose(socket)

exit

/* ------------------------------------------------------ */
SendMessage:     procedure expose !.
	sock = arg(1)
	data = arg(2) || d2c(13) || d2c(10)

	if (symbol('!.message_id') == "LIT") then !.message_id = 0

	!.message_id = right(!.message_id + 1, 4, '0')

	if !.debug \= '' then say 'Debug: >>> '!.message_id||' '||data

	len = length(data)
	do while (len > 0)
		len = SockSend(sock, !.message_id||' '||data);
		if (len <= 0) then
		Error(socket, 100, "server closed the connection.")
      
		data = substr(data,len+1)
		len  = length(data)
	end

	return len

GetResponse:     procedure expose line. !.
	sock = arg(1)

	line.0 = 0

	do forever
		o = line.0 + 1

		line.o = GetResponseLine(sock)
		
		if !.debug \= '' then say 'Debug: <<< 'line.o
		
		parse var line.o label .

		if (label == !.message_id) then return ""

		line.0 = o
	end

	return ""

GetResponseLine: procedure expose !.
	sock = arg(1)

	crlf = d2c(13) || d2c(10)

	if (symbol('!.buff') == "LIT") then !.buff = ""

	do while (pos(crlf,!.buff) == 0)
		rc = SockRecv(sock,"data",8000)
		!.buff = !.buff || data
	end

	/* say ' got data "' data '"' */
	/* say ' buff = "' !.buff '"' */

	p = pos(crlf, !.buff)

	line = substr(!.buff, 1, p-1)
	!.buff = substr(!.buff, p+2)

	return line


Error: procedure
	sock = arg(1)
	retc = arg(2)
	msg  = arg(3)

	if (sock <> -1) then
	rc = SockSoClose(sock)

	say "Error:" msg

	exit retc
